VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsTimedMeas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit
'*****************************************************************************
'The clsTimer class handles calls from the timer control
'and issues Measurement GPIB commands and reads the results from the scope.
'Reading results are passed to an ActiveX EXE component (xlInsert an instance of the
'p_ExcelInsert.CExcelInsert class).  The ActiveX Exe parses the results and pastes them into the
'appropriate Excel spreadsheet and charts if necessary.
'The timer class signals the ActiveX Exe when to update periodic charts and it also handles
'updating the processing progress bar onm_form.

'Class instances are created in frmMeasurememt.cmdStartStop_Click procedure
'*******************************************************************************

Private m_strCMD As String                              'class variable for scope GPIB command
Private m_Tracker As Long                               'tracks number of calls to the timer handler
Private m_timer As VB.Timer
'reference variable to the timer control so it may be disabled when sample count is reached
Private m_RecLength As Long
Private m_ChartingType As String
'variable to hold the number of measurement samples to capture
Private m_ChartUpdateInterval As Integer                'holds percentage frequency of chart updates
Private nCTracker As Integer
'tracking variable for updating charts
Public blnFirstUpdate As Boolean                        'flags xlInsert that it is the first update; signals it to to insert chart not just update values
Private m_form As MSForms.UserForm
Private m_TVCRef As Object
Private m_xlInsert As Object
Private m_EnableTimer As Boolean
Private m_TimerInterval As Long
'code sep


Private Sub Class_Initialize()
  m_ChartUpdateInterval = 0
  m_Tracker = 0
  m_ChartingType = "NONE"
  m_EnableTimer = False
  Load frmHoldTimer
  frmHoldTimer.tmrGM.Enabled = False
  Set m_timer = frmHoldTimer.tmrGM
  Set t = Me
 
End Sub
Public Sub HandleCountDown()
    
End Sub
Public Sub HandleTimer()
      Dim sRet As String
           
      ' disable timer if we have reached the end of the record length
      If m_Tracker >= m_RecLength Then
          m_timer.Enabled = False
          m_form.CommandButtonStart.Visible = True
          m_form.CommandButtonStop.Visible = False
          m_form.CommandButtonWaiting.Visible = False
'          m_form.cmdStartStop.Value = False 'reset the start/stop toggle button
          If m_ChartingType = "COMPLETION" Then
              Call m_xlInsert.ChartFlag("FIRST")   ' this will insert and draw all data points
              DoEvents
          ElseIf m_ChartingType = "PERIODIC" Then
              Call m_xlInsert.ChartFlag("UPDATE")   ' updates the chart with final data points
              DoEvents
          End If
          Exit Sub
      End If
                
      m_Tracker = m_Tracker + 1   ' increment the tracker variable
      m_form.lblCurrentNum.Caption = m_Tracker & " of:"
                
      With m_TVCRef      ' stop the scope; send the command; read the result
         .Lock
         .WriteString "ACQUIRE:STATE STOP"
         .WriteString m_strCMD
          sRet = .ReadString
          Debug.Print sRet
         .WriteString "ACQUIRE:STATE RUN"
         .Unlock
      End With
      
      m_xlInsert.strRet = sRet   ' send the result to m_xlInsert for processing
      If m_ChartingType = "PERIODIC" Then   ' check on chart updating for
          nCTracker = nCTracker + 1
          If nCTracker >= m_ChartUpdateInterval Then
              If blnFirstUpdate = True Then           ' check to see if this is the first update
                Call m_xlInsert.ChartFlag("FIRST")
                blnFirstUpdate = False                ' change the flag
              Else
                Call m_xlInsert.ChartFlag("UPDATE")
              End If
             nCTracker = 0  ' reset the chartupdate interval tracking variable
          End If
      End If
End Sub

Public Property Get strCMD() As String
  strCMD = m_strCMD
End Property

Public Property Let strCMD(ByVal sNewValue As String)
   m_strCMD = sNewValue
End Property


Public Property Get Tracker() As Long
   Tracker = m_Tracker
End Property

Public Property Let Tracker(ByVal lNewValue As Long)
    m_Tracker = lNewValue
End Property

Public Property Get reclength() As Long
   reclength = m_RecLength
End Property

Public Property Let reclength(ByVal lNewValue As Long)
 m_RecLength = lNewValue

End Property

Public Property Get ChartUpdateInterval() As Integer
   ChartUpdateInterval = m_ChartUpdateInterval
End Property

Public Property Let ChartUpdateInterval(ByVal nNewValue As Integer)
    m_ChartUpdateInterval = m_RecLength * (nNewValue / 100)
End Property

Public Property Set MeasForm(ByVal vNewValue As Variant)
   Set m_form = vNewValue
End Property
Public Property Set xlInsert(ByVal vNewValue As Variant)
   Set m_xlInsert = vNewValue
End Property


Public Property Get EnableTimer() As Boolean
    EnableTimer = m_EnableTimer
End Property


Public Property Let EnableTimer(ByVal bNewValue As Boolean)
     m_EnableTimer = bNewValue
     m_timer.Enabled = m_EnableTimer
End Property

Public Property Get TimerInterval() As Long
    TimerInterval = m_TimerInterval
End Property

Public Property Let TimerInterval(ByVal lNewValue As Long)
   m_TimerInterval = lNewValue
   m_timer.Interval = m_TimerInterval
End Property
Public Property Set MTVCRef(ByVal vNewValue As Variant)
  Set m_TVCRef = vNewValue
End Property
Private Sub Class_Terminate()
   If Not m_timer Is Nothing Then
      m_timer.Enabled = False
      Set m_timer = Nothing
   End If
   
   If Not m_xlInsert Is Nothing Then
      Set m_xlInsert = Nothing
   End If
   
   If Not m_form Is Nothing Then
      Set m_form = Nothing
   End If
   
   If Not m_TVCRef Is Nothing Then
      Set m_TVCRef = Nothing
   End If
      
      
End Sub

Public Property Get ChartingType() As String
   ChartingType = m_ChartingType
End Property

Public Property Let ChartingType(ByVal sNewValue As String)
   m_ChartingType = sNewValue
End Property
